#include <QtGui>

#include "NameChangeDlg.h"

#define MESSAGE \
	DirectQueryDlg::tr("<p>Message boxes have a caption, a text, " \
	"and any number of buttons, each with standard or custom texts." \
	"<p>Click a button to close the message box. Pressing the Esc button " \
"will activate the detected escape button (if any).")

NameChangeDlg::NameChangeDlg(QWidget *parent)
: QDialog(parent)
{
	tableNameLabel = new QLabel(tr("Table Name:"));
    tableNameEdit = new QLineEdit;
	
	okBtn		= new QPushButton(tr("Ȯ"));
	cancelBtn	= new QPushButton(tr(""));
	
	connect(okBtn, SIGNAL(clicked()), this, SLOT(clickOk()));
	connect(cancelBtn, SIGNAL(clicked()), this, SLOT(clickCancel()));
	
	QGridLayout  * nameLayout = new QGridLayout ;
	nameLayout->addWidget(tableNameLabel,0,0);
	nameLayout->addWidget(tableNameEdit,0,1);
	nameLayout->setAlignment(Qt::AlignTop | Qt::AlignCenter);
	
	QHBoxLayout * btnLayout = new QHBoxLayout;
	btnLayout->addWidget(okBtn);
	btnLayout->addWidget(cancelBtn);
	btnLayout->setAlignment(Qt::AlignBottom | Qt::AlignCenter);
	
    QVBoxLayout *queryBoxLayout = new QVBoxLayout;
	queryBoxLayout->addLayout(nameLayout);
	queryBoxLayout->addLayout(btnLayout);
	setLayout(queryBoxLayout);
	
	setGeometry(300,300,100,50);
	
    setWindowTitle(tr("̺ ̸"));
}

void NameChangeDlg::clickOk()
{
	if (!tableNameEdit->text().isEmpty()) 
	{ 
		accept();
		return;
    }
	
	QMessageBox::StandardButton EmptyTableName;
	EmptyTableName = QMessageBox::warning(this, tr("Incomplete Form"),
		tr("̺ ̸ Է ʾҽϴ.\n"
		"̸ ٲ ðڽϱ?"),
		QMessageBox::Yes | QMessageBox::No);
	
	if (EmptyTableName == QMessageBox::Yes)
		reject();
}

void NameChangeDlg::clickCancel()
{
	reject();
}

QString NameChangeDlg::sendTableName() const
{
	return tableNameEdit->text();
}
